#version 330
#extension GL_EXT_gpu_shader4 : enable
//Fractals practice v01Mod01.fsh  by  Endrju
//https://www.shadertoy.com/view/7tBSRm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))

vec3 ColsVecBase = vec3(.65, 0.61, .48);
vec3 ColsContrast = vec3(-.9, .3, -.8);

float velocity = 0.1;
float RotVal = 25.;
float Close_Up = .25;
float CosBaseStructure = cos(.02);
float SinBaseStructure = sin(.11);
float StructuralMultiplier = 2.1;
float BuildingBase = 1.22;
float StructDiff = 0.37;
float Noise = .005;
float FractStructurization = 41.92;
float ColChangeA = 13.;
float ColChangeB = 16.;
float Brightness = 1.35;
float OverallColPower = .95;
float ColComputingBase = 1.75;
float SS_Begin = 0.;
float SS_End = 12.;
float ColStrength = .65;
float DirX = 1.15;
float DirY = 2.;

int NumInterations = 26;

bool UseSin = false;

float CalcStructure(vec2 uv, vec2 bsv)
{
    float ColStep = 0.;
    
    for(int i = 0; i < NumInterations; i++)
    {
        uv *= BuildingBase;
        uv = abs(uv);
    	uv -= StructDiff;
    	uv -= bsv * min(0., dot(uv, bsv)) * 2.;
        uv.y += UseSin ? sin(uv.x * FractStructurization) * Noise : cos(uv.x * FractStructurization) * Noise;
        
        ColStep += dot(uv, uv);
    }
    
    return ColStep;
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    float TimeStep = iTime * velocity;
    
    vec2 uv = vec2(gl_FragCoord.xy - RotVal * iResolution.xy) / iResolution.y;
    uv += vec2(TimeStep * DirX, TimeStep * DirY);
    uv *= rot(RotVal);
    uv = fract(uv * Close_Up) - .5;
    uv = abs(uv);
    
    vec2 BasicStructureVec = vec2(CosBaseStructure, SinBaseStructure);
    
    float DotVal = dot(uv, BasicStructureVec);
    
    uv -= BasicStructureVec * max(0., DotVal) * StructuralMultiplier;
    
    float ColorStep = CalcStructure(uv, BasicStructureVec);
    
    vec3 Color = 1. - (.5 + ColStrength * cos(ColsVecBase *
    (ColorStep * ColChangeA + DotVal * ColChangeB) + ColsContrast));
    
    Color *= max(smoothstep(SS_Begin, SS_End, abs(uv.y)), OverallColPower);
    Color = pow(Color * Brightness, vec3(ColComputingBase));
    
    gl_FragColor = vec4(1. - exp(-Color), 1.);
}
